<?php
/* --------------------------------------------------------------
   SpecificTrackingCodeRequested.php 2020-03-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Events;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeId;

/**
 * Class SpecificTrackingCodeRequested
 *
 * @package Gambio\Admin\TrackingCode\Events
 */
class SpecificTrackingCodeRequested
{
    /**
     * @var TrackingCodeId
     */
    private $trackingCodeId;
    
    
    /**
     * GoingToFetchSpecificTrackingCodeEvent constructor.
     *
     * @param TrackingCodeId $trackingCodeId
     */
    private function __construct(TrackingCodeId $trackingCodeId)
    {
        $this->trackingCodeId = $trackingCodeId;
    }
    
    
    /**
     * @param TrackingCodeId $trackingCodeId
     *
     * @return SpecificTrackingCodeRequested
     */
    public static function create(TrackingCodeId $trackingCodeId): SpecificTrackingCodeRequested
    {
        return new self($trackingCodeId);
    }
    
    
    /**
     * @return TrackingCodeId
     */
    public function trackingCodeId(): TrackingCodeId
    {
        return $this->trackingCodeId;
    }
    
    
    /**
     * @param TrackingCodeId $trackingCodeId
     */
    public function replaceTrackingCodeId(TrackingCodeId $trackingCodeId): void
    {
        $this->trackingCodeId = $trackingCodeId;
    }
}